
namespace eval Deborah {

    proc controls {} {
	radiobox Deborah::verb "output format" "quiet verbose" "-q -v" -v
	radiobox Deborah::graph "subnet graph" "yes no" "-g {}" {}
	radiobox Deborah::subnet "generate subnets" "yes no" "-s {}" {}
    }

    proc command {} {
	if {"-s" == $Deborah::subnet} {
	    # asks where to save subnet files
	    set f [tk_getSaveFile -title "location and name prefix for subnets" \
		    -initialdir [file dirname $::buffer] \
		    -initialfile [file rootname [file tail $::buffer]][fileext]]
	    if {$f == ""} {return ""}
	    set zname "-z \"$f\""
	} else {
	    set zname ""
	}
	return "deborah $Deborah::verb $Deborah::graph $Deborah::subnet $zname"
    }

}


