/* Dmitry Zaitsev daze.ho.ua */
/* Petri net model of hypercube grid with terminal devices (a single transition) on borders */
/* d - number of dimensions, k - size of hypercube, p - number of packets in each buffer section, b - available buffer size */
/* output format - .net file of Tina www.laas.fr/tina */

#include <stdio.h>
#include <stdlib.h>

#define PUTINDX { for( u=1; u<=d; u++) printf( ".%d", i[u] ); }
#define PUTINDXNEXT( r ) { for( u=1; u<=d; u++) if( u != (r) ) printf( ".%d", i[u] ); else printf( ".%d", i[u]+1 ); }

#define IOBL 1

main( int argc, char * argv[] )
{
 int d,k,*i,j,u,v,dir,p,b;
 int loop, go;

 if( argc < 5 )
 {
   printf("*** USAGE: hcgen d k p b\n");
   exit(2);
 }
 else { d = atoi( argv[1] ); k = atoi( argv[2] ); p = atoi( argv[3] ); b = atoi( argv[4] );}

 i = (int *) malloc( (d+1)* sizeof( int ) );
 if( i == NULL )
 {
   printf( "*** not enough memory for i[]\n" );
   exit(2);
 }
 
 /* initialize index of the first grid node */
 for( j=1; j<=d; j++ ) i[j] = 1;

 loop=1;

 while( loop )
 {
   /* generate subnet for the current grid node */
   /* for on dimensions */
   for( j=1; j<=d; j++ )
   {
     /* direction 1 */
     /* output port */
     printf( "tr {to.d%d.n1", j );
     PUTINDX;
     printf( "} {pol.d%d.n1", j );
     PUTINDX;
     printf( "} {pb.d%d.n1", j );
     PUTINDX;
     printf( "} -> {po.d%d.n1", j );
     PUTINDX;
     printf( "} {pbl" );
     PUTINDX;
     printf( "}\n" );
     
     /* packets in the buffer section */
     printf("pl {pb.d%d.n1", j);
     PUTINDX;
     printf("} (%d)\n", p);
     
     /* port buffer size */
     printf("pl {pol.d%d.n1", j);
     PUTINDX;
     printf("} (%d)\n", IOBL);
     
     /* input port */
     for( v=1; v<=d; v++ )
       for( dir=1; dir<=2; dir++ )
	 if( (v!=j) || (dir!=1) )
	 {
	   printf( "tr {ti.d%d.n1.d%d.n%d", j, v, dir );
	   PUTINDX;
	   printf( "} {pi.d%d.n1", j );
	   PUTINDX;
	   printf( "} {pbl" );
	   PUTINDX;
	   printf( "} -> {pil.d%d.n1", j );
	   PUTINDX;
	   printf( "} {pb.d%d.n%d", v, dir );
	   PUTINDX;
	   printf( "}\n" );
	 } /* for v */
	 
	 /* port buffer size */
     printf("pl {pil.d%d.n1", j);
     PUTINDX;
     printf("} (%d)\n", IOBL);

     /* direction 2 */

     /* output port */
     printf( "tr {to.d%d.n2", j );
     PUTINDX;
     printf( "} {pil.d%d.n1", j );
     PUTINDXNEXT( j );
     printf( "} {pb.d%d.n2", j );
     PUTINDX;
     printf( "} -> {pi.d%d.n1", j );
     PUTINDXNEXT( j );
     printf( "} {pbl" );
     PUTINDX;
     printf( "}\n" );
       
     /* packets in the buffer section */
     printf("pl {pb.d%d.n2", j);
     PUTINDX;
     printf("} (%d)\n", p);

     /* input port */
     for( v=1; v<=d; v++ )
	 for( dir=1; dir<=2; dir++ )
	 if( (v!=j) || (dir!=2) )
	 {
	     printf( "tr {ti.d%d.n2.d%d.n%d", j, v, dir );
	     PUTINDX;
	     printf( "} {po.d%d.n1", j );
	     PUTINDXNEXT( j );
	     printf( "} {pbl" );
	     PUTINDX;
	     printf( "} -> {pol.d%d.n1", j );
	     PUTINDXNEXT( j );
	     printf( "} {pb.d%d.n%d", v, dir );
	     PUTINDX;
	     printf( "}\n" );
      } /* for v */
	   
     /* attached terminal devices */
     if(i[j]==1)
     {
	       printf( "tr {tt.d%d.n1", j );
	       PUTINDX;
	       printf( "} {po.d%d.n1", j );
	       PUTINDX;
	       printf( "} {pil.d%d.n1", j );
	       PUTINDX;
	       printf( "} -> {pi.d%d.n1", j );
	       PUTINDX;
	       printf( "} {pol.d%d.n1", j );
	       PUTINDX;
	       printf( "}\n" );
       }
       else if(i[j]==k)
       {
           printf( "tr {tt.d%d.n1", j );
	       PUTINDXNEXT( j );
	       printf( "} {pi.d%d.n1", j );
	       PUTINDXNEXT( j );
	       printf( "} {pol.d%d.n1", j );
	       PUTINDXNEXT( j );
	       printf( "} -> {po.d%d.n1", j );
	       PUTINDXNEXT( j );
	       printf( "} {pil.d%d.n1", j );
	       PUTINDXNEXT( j );
	       printf( "}\n" );
	       
	       /* port buffer size */
	       printf("pl {pol.d%d.n1", j);
	       PUTINDXNEXT( j );
	       printf("} (%d)\n", IOBL);
        
           printf("pl {pil.d%d.n1", j);
           PUTINDXNEXT( j );
           printf("} (%d)\n", IOBL);
       } 
	   
   } /* for j (on dimensions) */
   
   /* available size of the internal buffer */
   printf("pl {pbl" );
   PUTINDX;
   printf("} (%d)\n", b);

   /* calculate indices for the next grid node */
   go = 1;
   j=d;
   while( go )
   {
     (i[j])++;
     if( i[j] > k )
     {
       if( j == 1 ) { loop=0; go=0; }
       else
       {
	 i[j]=1;
	 j--;
       }
     }
     else go=0;
   } /* while go */
 } /* while loop */

 printf("net hc%dk%dp%db%d\n", d, k, p, b);
 free( i );
} /* main */

