/* Dmitry Zaitsev daze.ho.ua */
/* Petri net model of squre grid with terminal devices (a single transition) on borders   */
/* k - grid size, p - number of packets in each buffer section, b - available buffer size */
/* output format - .net file of Tina www.laas.fr/tina */

#include <stdio.h>
#include <stdlib.h>

#define IOBL 1

main( int argc, char * argv[] )
{
 int k,i,j,b,p;

 if( argc < 4 )
 {
   printf("*** USAGE: sgen k p b > sg-k-p-b.net\n");
   return(2);
 }
 else
 {
   k = atoi( argv[1] );
   p = atoi( argv[2] );
   b = atoi( argv[3] );
 }

 /* generate communication devices */
 for(i=1; i<=k; i++)
   for(j=1; j<=k; j++)
   {
     printf("tr {t1o.%d.%d} {p1ol.%d.%d} {pb1.%d.%d} -> {p1o.%d.%d} {pbl.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("tr {t1i2.%d.%d} {p1i.%d.%d} {pbl.%d.%d} -> {p1il.%d.%d} {pb2.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("tr {t1i3.%d.%d} {p1i.%d.%d} {pbl.%d.%d} -> {p1il.%d.%d} {pb3.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("tr {t1i4.%d.%d} {p1i.%d.%d} {pbl.%d.%d} -> {p1il.%d.%d} {pb4.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("pl {pb1.%d.%d} (%d)\n", i,j,p );
     printf("pl {p1ol.%d.%d} (%d)\n", i,j,IOBL );
     printf("pl {p1il.%d.%d} (%d)\n", i,j,IOBL );
     
     printf("tr {t4o.%d.%d} {p4ol.%d.%d} {pb4.%d.%d} -> {p4o.%d.%d} {pbl.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("tr {t4i1.%d.%d} {p4i.%d.%d} {pbl.%d.%d} -> {p4il.%d.%d} {pb1.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("tr {t4i2.%d.%d} {p4i.%d.%d} {pbl.%d.%d} -> {p4il.%d.%d} {pb2.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("tr {t4i3.%d.%d} {p4i.%d.%d} {pbl.%d.%d} -> {p4il.%d.%d} {pb3.%d.%d}\n", i,j, i,j, i,j, i,j, i,j );
     printf("pl {pb4.%d.%d} (%d)\n", i,j,p );
     printf("pl {p4ol.%d.%d} (%d)\n", i,j,IOBL );
     printf("pl {p4il.%d.%d} (%d)\n", i,j,IOBL );

     printf("tr {t3o.%d.%d} {p1il.%d.%d} {pb3.%d.%d} -> {p1i.%d.%d} {pbl.%d.%d}\n", i,j, i+1,j, i,j, i+1,j, i,j );
     printf("tr {t3i1.%d.%d} {p1o.%d.%d} {pbl.%d.%d} -> {p1ol.%d.%d} {pb1.%d.%d}\n", i,j, i+1,j, i,j, i+1,j, i,j );
     printf("tr {t3i2.%d.%d} {p1o.%d.%d} {pbl.%d.%d} -> {p1ol.%d.%d} {pb2.%d.%d}\n", i,j, i+1,j, i,j, i+1,j, i,j );
     printf("tr {t3i4.%d.%d} {p1o.%d.%d} {pbl.%d.%d} -> {p1ol.%d.%d} {pb4.%d.%d}\n", i,j, i+1,j, i,j, i+1,j, i,j );
     printf("pl {pb3.%d.%d} (%d)\n", i,j,p );

     printf("tr {t2o.%d.%d} {p4il.%d.%d} {pb2.%d.%d} -> {p4i.%d.%d} {pbl.%d.%d}\n", i,j, i,j+1, i,j, i,j+1, i,j );
     printf("tr {t2i1.%d.%d} {p4o.%d.%d} {pbl.%d.%d} -> {p4ol.%d.%d} {pb1.%d.%d}\n", i,j, i,j+1, i,j, i,j+1, i,j );
     printf("tr {t2i3.%d.%d} {p4o.%d.%d} {pbl.%d.%d} -> {p4ol.%d.%d} {pb3.%d.%d}\n", i,j, i,j+1, i,j, i,j+1, i,j );
     printf("tr {t2i4.%d.%d} {p4o.%d.%d} {pbl.%d.%d} -> {p4ol.%d.%d} {pb4.%d.%d}\n", i,j, i,j+1, i,j, i,j+1, i,j );
     printf("pl {pb2.%d.%d} (%d)\n", i,j,p );
     
     printf("pl {pbl.%d.%d} (%d)\n", i,j,b );
   }

 /* generate terminal devices */
 for(j=1; j<=k; j++)
 {
   /* upper */
   printf("tr {tf-u.%d} {p1o.%d.%d} {p1il.%d.%d} -> {p1ol.%d.%d} {p1i.%d.%d}\n", j, 1,j, 1,j, 1,j, 1,j );

   /* down */
   printf("tr {tf-d.%d} {p1i.%d.%d} {p1ol.%d.%d} -> {p1il.%d.%d} {p1o.%d.%d}\n", j, k+1,j, k+1,j, k+1,j, k+1,j );
   
   printf("pl {p1ol.%d.%d} (%d)\n", k+1,j,IOBL );
   printf("pl {p1il.%d.%d} (%d)\n", k+1,j,IOBL );
 }
 for(i=1; i<=k; i++)
 {
   /* left */
   printf("tr {tf-l.%d} {p4o.%d.%d} {p4il.%d.%d} -> {p4ol.%d.%d} {p4i.%d.%d}\n", i, i,1, i,1, i,1, i,1 );

   /* right */
   printf("tr {tf-r.%d} {p4i.%d.%d} {p4ol.%d.%d} -> {p4il.%d.%d} {p4o.%d.%d}\n", i, i,k+1, i,k+1, i,k+1, i,k+1 );
   
   printf("pl {p4ol.%d.%d} (%d)\n", i,k+1,IOBL );
   printf("pl {p4il.%d.%d} (%d)\n", i,k+1,IOBL );
 }
  
 printf("net nf2s%d\n", k);
} /* main */

